#include <SPI.h>
#include "printf.h"
#include "RF24.h"

RF24 radio(9, 10); // using pin 9 for the CE pin, and pin 10 for the CSN pin

// For this example, we'll be using 6 addresses; 1 for each TX node
// It is very helpful to think of an address as a path instead of as
// an identifying device destination
// Notice that the last byte is the only byte that changes in the last 5
// addresses. This is a limitation of the nRF24L01 transceiver for pipes 2-5
// because they use the same first 4 bytes from pipe 1.
uint64_t address[6] = {0x7878787878LL,
                       0xB3B4B5B6F1LL,
                       0xB3B4B5B6CDLL,
                       0xB3B4B5B6A3LL,
                       0xB3B4B5B60FLL,
                       0xB3B4B5B605LL
                      };

#define SIZE 32
String SendData = "Hallo JS";
char adressNumber = 4; // integers 0-5

// Teksten als laatste
// Hiervoor mag je long, bool, int gebruiken
struct DataObject
{
  unsigned long nodeID;
  unsigned long ObjectID;
  bool jaNee;
  int nummer;
  long normalLong;
  char textBuffer[SIZE + 1]; // Teksten moeten als laatste!
};
DataObject payload;

// This example uses all 6 pipes to receive while TX nodes only use 2 pipes
// To make this easier we'll use a function to manage the addresses, and the
// payload's nodeID
void setSendAdress(); // declare a prototype; definition is found after the loop()

void setup() {

  Serial.begin(9600);
  while (!Serial) {
    // some boards need to wait to ensure access to serial over USB
  }

  // initialize the transceiver on the SPI bus
  if (!radio.begin()) {
    Serial.println(F("radio hardware is not responding!!"));
    while (1) {} // hold in infinite loop
  }

  // print example's introductory prompt
  Serial.println(F("RF24/examples/MulticeiverDemo"));
  Serial.println(F("    the identifying node number that transmits."));

  // Set the PA Level low to try preventing power supply related problems
  // because these examples are likely run with nodes in close proximity of
  // each other.
  radio.setPALevel(RF24_PA_LOW); // RF24_PA_MAX is default.

  // save on transmission time by setting the radio to only transmit the
  // number of bytes we need to transmit a float
  radio.setPayloadSize(sizeof(payload)); // 2x int datatype occupy 8 bytes

  // Set the pipe addresses accordingly. This function additionally also
  // calls startListening() or stopListening() and sets the payload's nodeID
  setSendAdress(adressNumber);

  // For debugging info
  // printf_begin();             // needed only once for printing details
  // radio.printDetails();       // (smaller) function that prints raw register values
  // radio.printPrettyDetails(); // (larger) function that prints human readable data

  makePayload(1, SendData);
}

void loop() {

  //if (role <= 53)
  {
    // This device is a TX node

    unsigned long start_timer = micros();                    // start the timer
    bool report = radio.write(&payload, sizeof(payload));    // transmit & save the report
    unsigned long end_timer = micros();                      // end the timer

    if (report) {
      // payload was delivered

      Serial.print(F("Transmission of ObjectID "));
      Serial.print(payload.ObjectID);                       // print ObjectID
      Serial.print(F(" as node "));
      Serial.print(payload.nodeID);                          // print nodeID
      Serial.print(F(" text: "));
      String txt = payload.textBuffer;
      Serial.print(txt);                       // print text
      Serial.print(F(" Ja/Nee: "));
      Serial.print(payload.jaNee);                          // print nodeID
      Serial.print(F(" Nummer: "));
      Serial.print(payload.nummer);                          // print nodeID
      Serial.print(F(" Normal long: "));
      Serial.print(payload.normalLong);                          // print nodeID
      Serial.print(F(" successful!"));
      Serial.print(F(" Time to transmit: "));
      Serial.print(end_timer - start_timer);                 // print the timer result
      Serial.println(F(" us"));
    } else {
      Serial.println(F("Transmission failed or timed out")); // payload was not delivered
    }

    payload.ObjectID++;                                     // increment payload number
    payload.nummer = payload.ObjectID / 10;
    payload.normalLong = payload.ObjectID;

    // to make this example readable in the serial monitor
    delay(1000); // slow transmissions down by 1 second
  }
}

void setSendAdress(long nodeID) {
  // For the TX node

  // set the payload's nodeID & reset the payload's identifying number
  payload.nodeID = nodeID;
  payload.ObjectID = 0;
  payload.jaNee = false;

  // Set the address on pipe 0 to the RX node.
  radio.stopListening(); // put radio in TX mode
  radio.openWritingPipe(address[nodeID]);

  // According to the datasheet, the auto-retry features's delay value should
  // be "skewed" to allow the RX node to receive 1 transmission at a time.
  // So, use varying delay between retry attempts and 15 (at most) retry attempts
  radio.setRetries(((nodeID * 3) % 12) + 3, 15); // maximum value is 15 for both args
}

void makePayload(uint8_t i, String data) {
  // Make a single payload based on position in stream.
  // This example employs function to save memory on certain boards.

  // String data = "Hello John Sanders";
  // Length (with one extra character for the null terminator)
  int buffer_len = data.length() + 1;
  // Prepare the character array (the buffer)
  payload.textBuffer[buffer_len];
  // Copy it over
  data.toCharArray(payload.textBuffer, buffer_len);
}
